// loop_buf_intr.c 

#include "audio.h"

volatile int16_t audio_chR=0;    
volatile int16_t audio_chL=0;    

#define BUFFER_SIZE 256

float32_t rbuffer[BUFFER_SIZE];
int16_t rbufptr = 0;
float32_t lbuffer[BUFFER_SIZE];
int16_t lbufptr = 0;


void I2S_HANDLER(void) {   /****** I2S Interruption Handler *****/

audio_IN = i2s_rx();	
audio_chL = (audio_IN & 0x0000FFFF);       
audio_chR = ((audio_IN >>16)& 0x0000FFFF); 

    lbuffer[lbufptr] = (float32_t)(audio_chL);
	  rbuffer[rbufptr] = (float32_t)(audio_chR);
    lbufptr = (lbufptr+1) % BUFFER_SIZE;
    rbufptr = (rbufptr+1) % BUFFER_SIZE;
	
audio_OUT = ((audio_chR<<16 & 0xFFFF0000)) + (audio_chL & 0x0000FFFF);	
i2s_tx(audio_OUT);

}

int main(void)
{
  audio_init ( hz48000, line_in, intr, I2S_HANDLER); 
 
  while(1){}
}

