/*!
 * \file      audio.h
 * \brief     Implements the audio configuration
 * \copyright ARM University Program &copy; ARM Ltd 2014.
 *
 */

#ifndef audio_H
#define audio_H

#define ARM_MATH_CM4

#include "MK64F12.h"
#include "arm_math.h"
#include "delay.h"
#include "gpio.h"
#include "i2c.h"
#include "i2s.h"
#include "dma.h"


//Variables used to move the audio data.

static volatile uint32_t audio_IN=0;     //two channels of 16 bits audio data IN
static volatile uint32_t audio_OUT=0;    //two channels of 16 bits audio data OUT

//Using DMA
static uint32_t dma_tx_buffer_pong[DMA_BUFFER_SIZE], 
dma_tx_buffer_ping[DMA_BUFFER_SIZE], 
dma_rx_buffer_ping[DMA_BUFFER_SIZE], 
dma_rx_buffer_pong[DMA_BUFFER_SIZE];
	
static volatile uint32_t rx_proc_buffer = PING;
static volatile uint32_t tx_proc_buffer = PING;
static volatile int tx_buffer_empty = 0;
static volatile int rx_buffer_full = 0;


#define NOISELEVEL 8000


/* The address of the codec is set by the state of the CSB pin */
#define CODEC_DEVICE_ADDRESS   0x1A    // 0011010


/*! This enum describes the different sampling frequency setup of the CODEC */
typedef enum {
      hz8000 =  0x11,   
      hz16000 = 0x12,  
      hz24000 = 0x02,  
      hz32000 = 0x13,   
      hz48000 = 0x03,  
    } sampling_rate;    

/*! This enum describes the different input setup of the CODEC */		
typedef enum {
	    mic_in = 0,
      line_in = 1,  // Select DAC input Line In and disable bypass
      dmic_in = 2,   // Select DAC input Microphone In and disable bypass 
    } audio_input;    

/*! This enum describes the different input setup of the CODEC */		
typedef enum {
      intr = 0x00,  // User I2S interruptions to controll the flow of the program (generate interruption when  irq_depth=<FIFO level)
      dma = 0x01,   // Use DMA requests to controll the flow of the program (generat a request whem dma_depth=<FIFO level)
    } mode;    		
		
/*! \brief Initialize the 4 on-board LEDS */	
void init_LED(void);		
		
/*! \brief Creat a pseud-random value */			
short prbs(void);
		
/*! \brief Configures the audio part of the QSB Base Board
* Configure the freescale and the CODEC
*
* Requires: 
*
*   \param sampling_rate; hz8000, hz32000, hz48000, hz96000
*   \param audio_input; line_in, mic_in;
* 
* Description: 
* Configure the I2C protocol
* Write via I2C into the CODEC registers to configure it. 
* Configure the I2S protocol
* Configure the interruptions or the DMA to work with the I2S RX FIFO and TX FIFO
*/ 

void  audio_init ( char sampling_rate, char audio_input, char mode,void (*handler)(void));

	
#endif // audio_H
// *******************************ARM University Program Copyright  ARM Ltd 2014*************************************   
