
#include "MK64F12.h"
#include "platform.h"
#include "audio.h"
#include "dma.h"

/*! \brief Reads the interruption status*/					 
uint32_t dma_state(unsigned char ChannelNum){
	return (DMA0->INT & (1UL << (ChannelNum)));
};								 
/*! \brief Clean the interrupt requests. */						 
void dma_clean(unsigned char ChannelNum){
	DMA0->CINT = DMA_CINT_CINT(ChannelNum);
};		
/*! \brief Rewrite the memory source address */						 
void dma_src_memory(unsigned char ChannelNum, unsigned int address){
    DMA0->TCD[ChannelNum].SADDR = (uint32_t)address;
};		

/*! \brief Rewrite the memory destination address */							 
void dma_dest_memory(unsigned char ChannelNum, unsigned int address){
		DMA0->TCD[ChannelNum].DADDR = (uint32_t)address;
};			

/*! \brief Write the data transfer size. */							 
void dma_transfersize(unsigned char ChannelNum, unsigned int size){
    //No need of rewrite the size of the transfer.
	};	

/* Name: dma_init   
* Description: Initialization DMA   
*/    

void dma_init(void) {   
  SIM->SCGC7 |= SIM_SCGC7_DMA_MASK;          // enable DMA Clock                             
  SIM->SCGC6 |= SIM_SCGC6_DMAMUX_MASK;       // enable DMA MUX clock                              

  DMA0->CR = (uint32_t)((DMA0->CR & (uint32_t)~(uint32_t)(
        DMA_CR_CX_MASK  |  //cx; cancel transfer; 0=normal operation
        DMA_CR_ECX_MASK |  //exc; Error cancel transfer; 0=normal operation
        DMA_CR_CLM_MASK |  //clm; Continuous Link Mode; channel arbitration
        DMA_CR_HALT_MASK|  //halt; Halt DMA operations; 0=normal operation
        DMA_CR_HOE_MASK |  //hoe; Halt on error; 0=normal operation
        DMA_CR_ERCA_MASK|  //erca; Fixed priority is used to select channel
        DMA_CR_EDBG_MASK   //edbg; Enable normal operation in debug mode           
	      )) | (uint32_t)( 
	     DMA_CR_EMLM_MASK));    //emlm; Minor Loop Maping enable.
             
  DMA0->DCHPRI0=0; //Different priorities must be set for all channels                        
  DMA0->DCHPRI1=1; 
  DMA0->DCHPRI2=2;                         
  DMA0->DCHPRI3=3;   
  DMA0->DCHPRI4=4;                        
  DMA0->DCHPRI5=5; 
  DMA0->DCHPRI6=6;                         
  DMA0->DCHPRI7=7;  
  DMA0->DCHPRI8=8;                         
  DMA0->DCHPRI9=9; 
  DMA0->DCHPRI10=10;                         
  DMA0->DCHPRI11=11;  
  DMA0->DCHPRI12=12;                       
  DMA0->DCHPRI13=13; 
  DMA0->DCHPRI14=14;                         
  DMA0->DCHPRI15=15;  	

	 DMA0->TCD[0].CSR &= ~(DMA_CSR_ACTIVE_MASK); 
// Disable DMA channel 0 while configuring 

// Configure channel 0 for transmission. 

  DMA0->TCD[0].SADDR = (uint32_t)(dma_tx_buffer_ping);         
//Source Address; Memory address pointing to the source data.                                                                                                                   
  DMA0->TCD[0].SOFF = DMA_SOFF_SOFF(4);           
//4 bytes source offset after each (32-bit) transfer.                                
  DMA0->TCD[0].ATTR = 0x0202;	
//32-bits source and destination data transfer size.				
  DMA0->TCD[0].NBYTES_MLNO = DMA_NBYTES_MLNO_NBYTES(sizeof(uint32_t));
//Transfer 4bytes in each service request.
  DMA0->TCD[0].SLAST = DMA_SLAST_SLAST(0x00);                
//Last source Address Adjustment.   
  DMA0->TCD[0].DADDR = (uint32_t)(&I2S0->TDR[0]);      
// Memory address pointing to the data destination address (I2S0_TDR0).
  DMA0->TCD[0].DOFF = (0);           
//No destination offset; Destination is always the Tx_I2S FIFO.  
  DMA0->TCD[0].DLAST_SGA = DMA_DLAST_SGA_DLASTSGA(0x00);
//Destination last address.	
  DMA0->TCD[0].CITER_ELINKNO = DMA_CITER_ELINKNO_CITER(DMA_BUFFER_SIZE) ;    
  DMA0->TCD[0].BITER_ELINKNO = DMA_BITER_ELINKNO_BITER(DMA_BUFFER_SIZE);
//Major loop iteration counter -> total samples (DMA_bufer_size).                            
  DMA0->ERQ &= ~DMA_ERQ_ERQ0_MASK;         
//The DMA request signal is disabled.     
  DMA0->TCD[0].CSR =  DMA_CSR_DONE_MASK | DMA_CSR_INTMAJOR_MASK
                                        | DMA_CSR_BWC(3);
//Enable interruption when major lop is done.
  DMA0->ERQ |= DMA_ERQ_ERQ0_MASK;         
//The DMA request signal for the channel 0 is enabled.   

  DMAMUX->CHCFG[0] = ((0x8D)); 
// select DMA channel 1 source to number 13 (I2S0 Transmit)using DMA MUX  

// Configure channel 1 for reception.

  DMA0->TCD[1].SADDR = (uint32_t)(&I2S0->RDR[0]);           
//Source Address; Memory address pointing to the source data.                                                          
  DMA0->TCD[1].SOFF = DMA_SOFF_SOFF(0);       
//No source offset after transfer. Always read data from I2S_RX FIFO buffer                                
  DMA0->TCD[1].ATTR = 0x0202;	
//32-bits source and destination data transfer size.						
  DMA0->TCD[1].NBYTES_MLNO = DMA_NBYTES_MLNO_NBYTES(sizeof(uint32_t));
//Transfer 4bytes (32bits) in each service request.
  DMA0->TCD[1].SLAST = DMA_SLAST_SLAST(0x00);                
//Last source address adjustment.   
  DMA0->TCD[1].DADDR = (uint32_t)((dma_rx_buffer_ping));     
//Destination Address; Memory address pointing to the destination.
  DMA0->TCD[1].DOFF = DMA_DOFF_DOFF(sizeof(uint32_t));       
//Destination address offset is 4 bytes.
  DMA0->TCD[1].DLAST_SGA = DMA_DLAST_SGA_DLASTSGA(0x00);
//Destination last address.
  DMA0->TCD[1].CITER_ELINKNO = DMA_CITER_ELINKNO_CITER(DMA_BUFFER_SIZE) ;  
  DMA0->TCD[1].BITER_ELINKNO = DMA_BITER_ELINKNO_BITER(DMA_BUFFER_SIZE);
//Major loop iteration counter -> total samples (DMA_bufer_size).                            
  DMA0->ERQ &= ~DMA_ERQ_ERQ1_MASK;
// The DMA request signal is disabled      
  DMA0->TCD[1].CSR =  DMA_CSR_DONE_MASK | DMA_CSR_INTMAJOR_MASK;   
//Enable interruption when major lop is done.
  DMA0->ERQ |= DMA_ERQ_ERQ1_MASK;         
// The DMA request signal for the channel 0 is enabled.     

  DMAMUX->CHCFG[1] = ((0x8C)); 
// select DMA channel 1 source to number 12 (I2S0 Receive)using DMA MUX
     

}

void dma_setup(char ChannelNum, unsigned int SrcMemAddr,unsigned int DstMemAddr, unsigned int SrcPeriph, unsigned int DstPeriph, unsigned int TransferSize, unsigned int BurstSize, unsigned int TransferWidth, unsigned int TransferType,  unsigned int Dmalli  ){
	 //Not implemented. The setup is done in the init function.	
	}

/* Name: dma_enable  
* Description: Enable the chosen dma channel
*/  
	void dma_enable(unsigned char ChannelNum){
		
  DMA0->TCD[ChannelNum].CSR |= DMA_CSR_ACTIVE_MASK;      
	}		
	
/* Name: dma_disable  
* Description: Disable the chosen dma channel
*/  
	void dma_disable(unsigned char ChannelNum){
		
 DMA0->TCD[ChannelNum].CSR &= ~DMA_CSR_ACTIVE_MASK;      
	}		
	
	static void (*dma_callback)(void) = 0;

void dma_set_callback(void (*callback)(void)) {
	 dma_callback = callback;

   NVIC_ClearPendingIRQ(DMA0_IRQn);
   NVIC_EnableIRQ(DMA0_IRQn);
	 NVIC_EnableIRQ(DMA1_IRQn);
   
}

//Interruption call the callback function 

 void DMA0_IRQHandler(void) {
	if (dma_callback) {
		dma_callback();
	}
}

 void DMA1_IRQHandler(void) {
	 if (dma_callback) {
		dma_callback();
	}

}

	
// *******************************ARM University Program Copyright © ARM Ltd 2014*************************************   
