/*!
 * \file      i2c.h
 * \brief     Controller for hardware I2C module, configured
 *            as a master.
 * \copyright ARM University Program &copy; ARM Ltd 2014.
 */
#ifndef I2C_H
#define I2C_H

/*! \brief Initialises the hardware I2C module, and any
 *         relevant pins.
 */
void i2c_init(void);

/*! \brief Enables the I2C module. */
void i2c_enable(void);

/*! \brief Transmits the specified character.
 *  \param c Character to send.
 */
void i2c_tx(unsigned char c);

/*! \brief Receives a character from a slave.
 *  \return Received character.
 */
unsigned char i2c_rx(void);

/*! \brief Sends an I2C start bit (SCL high, SDA high -> low). */
void i2c_start(void);

/*! \brief Sends an I2C stop bit (SCL high, SDA low -> high). */
void i2c_stop(void);

/*! \brief Sends an ACK (pulls SDA low). */
void i2c_ack(void);

/*! \brief Sends an NACK (leaves SDA high).
 *         Used to signal the end of a transmission.
 */
void i2c_nack(void);

#endif //I2C_H
