
#include <LPC407x_8x_177x_8x.h>
#include "platform.h"
#include "i2c.h"

// IF YOU ARE USING THE QSB BASE BOARD BE SURE THAT JUMPERS JP8 & JP9 ARE AT 2-3 POSITION

/* Name: i2c_init   
* Description: Initialization I2C bus clock and Pins.   
* Transmition frequency 100KHz. 
* I2C0 SDA P1_30
* I2C0_SCK P1_31
*/    

void i2c_init() {   

LPC_SC->PCONP |= (1 << 7);  //Power control pheriperals For I2C0
LPC_SC->PCLKSEL = 4; 
i2c_enable();
// Clock frequency = (CLK/PCLKSEL)/(I2CSCLH+I2CSCLL) = 30M/300 = 100khz standard frequency clock.
LPC_I2C0->SCLH = 0x96; // CSCLH = 150
LPC_I2C0->SCLL = 0x96; // CSCLH = 150

// Configure GPIO’s     
LPC_IOCON -> P1_30 = 0xA4;  //I2C0 SDA  
LPC_IOCON -> P1_31 = 0xA4;  //I2C0_SCK
	
}

/* Name: i2c_enable  
* Description: Enable i2c module
*/  
void i2c_enable(){
LPC_I2C0->CONSET = 0x40; // Enable I2C
}

/* Name: i2c_Start  
* Description: Send the start signal (master)
*/  
void i2c_start(){

LPC_I2C0->CONSET =0x60;  //transmit start
}

/* Name: i2c_Stop  
* Description: Make the stop signal (master)
* The master disable any transmissions.
*/  
void i2c_stop(){

LPC_I2C0->CONSET = 0x10; // Desable transmission
LPC_I2C0->CONCLR = 0x08; //Clear SI

}

/* Name: i2c_tx     
* Description: Puts data in de data register for send.  
*/
void i2c_tx(unsigned char c){
	LPC_I2C0->DAT = c;  
}

/* Name: i2c_rx     
* Description: Reads data from the data register  
*/

unsigned char i2c_rx(void){
return 	LPC_I2C0->DAT ;
}


/* Name: i2c_ack     
* Description: Reads data from the data register  
*/

void i2c_ack(){
	LPC_I2C0->CONSET = 0x04;   
}
// *******************************ARM University Program Copyright © ARM Ltd 2014*************************************   
