
#include "leds.h"
#include "STM32F4xx.h"


#define Green  12
#define Orange 13
#define Red    14
#define Blue   15
#define LOOP_COUNT 0x3fffff


/*------------------------------------------------------------------------------
	Example for initialising 4 on board LEDs
	*------------------------------------------------------------------------------*/
void Delay (uint32_t nCount)
{
	while(nCount--)
	{
			__NOP();
	}
}


/*------------------------------------------------------------------------------
	Example for initialising 4 on board LEDs
	*------------------------------------------------------------------------------*/
void Init_LEDs(void){
		
		//Enable clock to port D		
		RCC->AHB1ENR|=RCC_AHB1ENR_GPIODEN;

	
		//Configure the pins which are conenected to the on board LEDs
		//to be output
		GPIOD->MODER|=(GPIO_MODER_MODER12_0|//Green
					   GPIO_MODER_MODER13_0|//Orange
					   GPIO_MODER_MODER14_0|//Red
					   GPIO_MODER_MODER15_0);//Blue

}


/*------------------------------------------------------------------------------
	Turn a specific LED on
	*------------------------------------------------------------------------------*/
void Turn_On_LED (int LED) {

			//Turn light on
			GPIOD->BSRRL=(1UL<<(LED));

}

/*------------------------------------------------------------------------------
	Turn a specific LED off
	*------------------------------------------------------------------------------*/
void Turn_Off_LED (int LED) {

			//Turn light off
			GPIOD->BSRRH=(1UL<<(LED));

}

/*------------------------------------------------------------------------------
	Turn a specific LED on and off
	*------------------------------------------------------------------------------*/
void Turn_On_Off_LED (int LED) {

			//Turn light on
			GPIOD->BSRRL=(1UL<<(LED));
			Delay(LOOP_COUNT);
			GPIOD->BSRRH=(1UL<<(LED));
			Delay(LOOP_COUNT);
}

// *******************************ARM University Program Copyright  ARM Ltd 2013*************************************   
