
#include "STM32F4xx.h"

/*----------------------------------------------------------------------------
  Delay Function
 *----------------------------------------------------------------------------*/
void Delay (uint32_t nCount)
{
	while(nCount--)
	{
			__NOP();
	}
}

/*----------------------------------------------------------------------------
  Intializing the DAC2 as 12-bit right alignment DAC
	And the corresponding GPIO
 *----------------------------------------------------------------------------*/
void Init_DAC2(void){
	
	//Enable the clock for DAC module and GPIO Port A
	RCC->AHB1ENR|=RCC_AHB1ENR_GPIOAEN;
	RCC->APB1ENR|=RCC_APB1ENR_DACEN;
	
	//Configure the PoRT A pin 5 to be the Analogue
	GPIOA->MODER|=GPIO_MODER_MODER5;
	GPIOA->PUPDR&=~(GPIO_PUPDR_PUPDR5);

	//Enable the DAC
	DAC->CR|=DAC_CR_EN2;
	
	//Write to the DAC channel1 12-bit right-aligned data holding register
	DAC->DHR12R2=0;
	
}


/*----------------------------------------------------------------------------
  MAIN function
	Changing the way that count change can create different waveform
 *----------------------------------------------------------------------------*/
int main(void)
{
	u16 count=0;
	Init_DAC2();
	
	while(1){
		DAC->DHR12R2=count;	
		count=count+20;
		Delay(0x3fffff);
		}

}


// *******************************ARM University Program Copyright  ARM Ltd 2013*************************************   

