


#include "LPC11xx.h"
#include "LCD_4bit.h"

#define MASK(x) (1UL << (x))
#define LOOP_COUNT 0x3ffff



/*------------------------------------------------------------------------------
	Example for initialising on-board LED
	Using PIO0_7
	*------------------------------------------------------------------------------*/
void Init_LED(void){
		
		//Enable AHB clock to the GPIO domain	
		LPC_SYSCON->SYSAHBCLKCTRL |= (1<<6);	
		//Set the direction for GPIO
		LPC_GPIO0->DIR |= MASK(7);
}


/*------------------------------------------------------------------------------
	Example for initialising an external speaker
	Connect the speaker (with a cpacitor and optional resistor) to PIO1_11
	and the GND
	*------------------------------------------------------------------------------*/
void Init_Speaker(void){

		//Enable AHB clock to the GPIO domain	
		LPC_SYSCON->SYSAHBCLKCTRL |= (1<<6);
		//Set the direction for GPIO
		LPC_GPIO1->DIR |= MASK(11);

}

/*------------------------------------------------------------------------------
	Making various sounds depending on the frequency
	*------------------------------------------------------------------------------*/

void Speaker_Beep(uint32_t frequency){
	
	Init_Speaker();

	
	while(1){
			LPC_GPIO1->DATA|= (MASK(11));
			Delay(frequency);
			LPC_GPIO1->DATA&= ~(MASK(11));
			Delay(frequency);
	}

}


/*------------------------------------------------------------------------------
	Turn the led on and off and repeat
	*------------------------------------------------------------------------------*/

void Blinking_Lights (void) {
	
		Init_LED();
		
		while(1){
			//Turn light on
			LPC_GPIO0->DATA |= (MASK(7));
			Delay(LOOP_COUNT);
			//Turn light off
			LPC_GPIO0->DATA &= ~(MASK(7));
			Delay(LOOP_COUNT);
		}

}


/*------------------------------------------------------------------------------
	Example for switching LEDs using external switch
	Connect the switches to PIO1_11 and the GND
	*------------------------------------------------------------------------------*/
void 	Basic_Light_Switching_Example(void){
			
		Init_LED();

	
		//Set the direction as Input
		LPC_GPIO1->DIR &= ~MASK(11);
	
		while(1){
			//See whether the switch is on (or the button is pressed)
			//If pressed, then the pin should be grounded, then turn the lights on
			if(!(LPC_GPIO1->DATA & MASK(11))){
			LPC_GPIO0->DATA|= (MASK(7));
			}
			//If not, then the pin should be high, then turn the lights off
			else{
			LPC_GPIO0->DATA &= ~(MASK(7));
			}
		}			

}


/*------------------------------------------------------------------------------
	Example for Using LCD module
	*------------------------------------------------------------------------------*/

void LCD_Example(void) {
	Init_LCD();
	Clear_LCD();
	Set_Cursor(0,0);
	Print_LCD("Hi,World!");
	Set_Cursor(0,1);
	Print_LCD("LCD Test");
}



int main(void)
{
	//Uncomment to run a demo
	
	Blinking_Lights();
	
	//Basic_Light_Switching_Example();
	
	//Speaker_Beep(20000);
	
	//LCD_Example();

}

// *******************************ARM University Program Copyright  ARM Ltd 2013*************************************   
