#include "LCD_4bit.h"
#include <stdint.h>


void Delay (uint32_t nCount)
{
	while(nCount--)
	{
			__NOP();
	}
}



static uint8_t lcd_read_status(void)
{
  uint8_t status;

  SET_LCD_DATA_DIR_IN
  SET_LCD_RS(0)
  SET_LCD_RW(1)
  Delay(delay_2_ms);
  SET_LCD_E(1)
  Delay(delay_2_ms);
  status  = GET_LCD_DATA_IN << 4;
  SET_LCD_E(0)
  Delay(delay_2_ms);
  SET_LCD_E(1)
  Delay(delay_2_ms);
  status |= GET_LCD_DATA_IN;
  SET_LCD_E(0)
  SET_LCD_DATA_DIR_OUT
	Delay(delay_2_ms);
  return(status);
}

void wait_while_busy(void)
{
	for( ; lcd_read_status() & LCD_BUSY_FLAG_MASK; )
		;
}

void lcd_write_4bit(uint8_t c)
{
  SET_LCD_RW(0)
  SET_LCD_E(1)
  SET_LCD_DATA_OUT(c&0x0F)
  Delay(delay_2_ms);
  SET_LCD_E(0)
  Delay(delay_2_ms);
}

void lcd_write_cmd(uint8_t c)
{
  wait_while_busy();

  SET_LCD_RS(0)
	SET_LCD_RW(0)
  lcd_write_4bit(c>>4);
  lcd_write_4bit(c);
	Delay(delay_2_ms);
}

static void lcd_write_data(uint8_t c)
{
  wait_while_busy();

  SET_LCD_RS(1)
  lcd_write_4bit(c>>4);
  lcd_write_4bit(c);
	Delay(delay_2_ms);
}

void lcd_putchar(char c)
{ 
  lcd_write_data(c);
}

void lcd_init_port(void) {
	/* Enable clocks for peripherals        */
  ENABLE_LCD_PORT_CLOCKS                          
}

void Init_LCD(void)
{ 
	/* initialize port(s) for LCD */
	lcd_init_port();
	
  /* Set all pins for LCD as outputs */
  SET_LCD_ALL_DIR_OUT
  Delay(delay_20_ms);
  SET_LCD_RS(0)
  lcd_write_4bit(0x3);                 
  Delay(delay_20_ms);
  lcd_write_4bit(0x3);
  Delay(delay_20_ms);
  lcd_write_4bit(0x3);
  lcd_write_4bit(0x2);
  lcd_write_cmd(0x28);                 
  lcd_write_cmd(0x0C);                 
  lcd_write_cmd(0x06);                 
  lcd_write_cmd(0x80);                 
}



void Set_Cursor(uint8_t column, uint8_t row)
{
  uint8_t address;

  address =(row * 0x40) + column;
	address |= 0x80;
  lcd_write_cmd(address);               
}

void Clear_LCD(void)
{
  lcd_write_cmd(0x01);                 
  Set_Cursor(0, 0);
}

void Print_LCD(char *string)
{
  while(*string)  {
    lcd_putchar(*string++);
  }
}


// *******************************ARM University Program Copyright  ARM Ltd 2013*************************************   

