#include "LPC11xx.h"

#define LCD_COLUMNS   8   // Number of LCD columns in characters
#define LCD_ROWS     	2   // Number of LCD rows

#define delay_2_ms    8732
#define delay_20_ms   delay_2_ms*10

/*-------------------- LCD interface hardware definitions --------------------*/

/* Connections from LCD to MCU port bits: 
 DB4 through DB8 are contiguous, starting with LSB at bit position PIN_DATA_SHIFT
 
  For example:
   - DB4 = 2.6
   - DB5 = 2.7
   - DB6 = 2.8
   - DB7 = 2.9
	 
   - E   = 1.10
   - RW  = 1.11
   - RS  = 2.10                                                              */

#define PIN_DATA_PORT					LPC_GPIO2
#define PIN_DATA_PT						LPC_GPIO2
#define PIN_DATA_SHIFT				( 6 )

#define PINS_DATA             (0xf<< (PIN_DATA_SHIFT))


#define PIN_DATA_PORT_4				LPC_GPIO2
#define PIN_DATA_PT_4					6
#define PIN_DATA_SHIFT_4			( PIN_DATA_PT_4 )
#define PIN_DATA_4            ( 1 << PIN_DATA_SHIFT_4)
#define PIN_DATA_4_01         (01 << (PIN_DATA_SHIFT_4*2))
#define PIN_DATA_4_11         (11 << (PIN_DATA_SHIFT_4*2))

#define PIN_DATA_PORT_5				LPC_GPIO2
#define PIN_DATA_PT_5					7
#define PIN_DATA_SHIFT_5			( PIN_DATA_PT_5 )
#define PIN_DATA_5            ( 1 << PIN_DATA_SHIFT_5)
#define PIN_DATA_5_01         (01 << (PIN_DATA_SHIFT_5*2))
#define PIN_DATA_5_11         (11 << (PIN_DATA_SHIFT_5*2))


#define PIN_DATA_PORT_6				LPC_GPIO2
#define PIN_DATA_PT_6					8
#define PIN_DATA_SHIFT_6			( PIN_DATA_PT_6 )
#define PIN_DATA_6            ( 1 << PIN_DATA_SHIFT_6)
#define PIN_DATA_6_01         (01 << (PIN_DATA_SHIFT_6*2))
#define PIN_DATA_6_11         (11 << (PIN_DATA_SHIFT_6*2))

#define PIN_DATA_PORT_7				LPC_GPIO2
#define PIN_DATA_PT_7					9
#define PIN_DATA_SHIFT_7			( PIN_DATA_PT_7 )
#define PIN_DATA_7            ( 1 << PIN_DATA_SHIFT_7)
#define PIN_DATA_7_01         (01 << (PIN_DATA_SHIFT_7*2))
#define PIN_DATA_7_11         (11 << (PIN_DATA_SHIFT_7*2))


#define PIN_E_PORT						LPC_GPIO1
#define PIN_E_PT							10
#define PIN_E_SHIFT						( PIN_E_PT )
#define PIN_E                 ( 1 << PIN_E_SHIFT)
#define PIN_E_01              (01 << (PIN_E_SHIFT*2))

#define PIN_RW_PORT						LPC_GPIO1
#define PIN_RW_PT							11
#define PIN_RW_SHIFT					( PIN_RW_PT	 )
#define PIN_RW                ( 1 <<PIN_RW_PT	)
#define PIN_RW_01             (01 << (PIN_RW_SHIFT*2))

#define PIN_RS_PORT						LPC_GPIO2
#define PIN_RS_PT							10
#define PIN_RS_SHIFT	        ( PIN_RS_PT	 )
#define PIN_RS                ( 1 << PIN_RS_SHIFT)
#define PIN_RS_01             (01 << (PIN_RS_SHIFT*2))


/* Enable Clock for peripheral driving LCD pins                               */
#define ENABLE_LCD_PORT_CLOCKS   	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<6);	

// #define SET_LCD_E(x)              if (x) {PIN_E_PORT->MASKED_ACCESS[PIN_E] |= PIN_E;} else {PIN_E_PORT->MASKED_ACCESS[PIN_E]&=~PIN_E;}
// #define SET_LCD_RW(x)             if (x) {PIN_RW_PORT->MASKED_ACCESS[PIN_RW] |= PIN_RW;} else {PIN_RW_PORT->MASKED_ACCESS[PIN_RW]&=~PIN_RW;}
// #define SET_LCD_RS(x)             if (x) {PIN_RS_PORT->MASKED_ACCESS[PIN_RS] |= PIN_RS;} else {PIN_RS_PORT->MASKED_ACCESS[PIN_RS]&=~PIN_RS;}
#define SET_LCD_E(x)              if (x) {PIN_E_PORT->DATA |= PIN_E;} else {PIN_E_PORT->DATA&=~PIN_E;}
#define SET_LCD_RW(x)             if (x) {PIN_RW_PORT->DATA |= PIN_RW;} else {PIN_RW_PORT->DATA&=~PIN_RW;}
#define SET_LCD_RS(x)             if (x) {PIN_RS_PORT->DATA |= PIN_RS;} else {PIN_RS_PORT->DATA&=~PIN_RS;}  


#define SET_LCD_DATA_OUT(x)   PIN_DATA_PORT->DATA=((PIN_DATA_PORT->DATA&~(PINS_DATA))|((x&0x0f)<<PIN_DATA_SHIFT));																												

#define GET_LCD_DATA_IN      (((PIN_DATA_PORT->DATA& PINS_DATA) >> PIN_DATA_SHIFT) & 0x0F)


/* Setting all pins to output mode                                            */
#define SET_LCD_ALL_DIR_OUT     { PIN_DATA_PORT_4->DIR |= PIN_DATA_4; \
																PIN_DATA_PORT_5->DIR |= PIN_DATA_5; \
																PIN_DATA_PORT_6->DIR |= PIN_DATA_6; \
																PIN_DATA_PORT_7->DIR |= PIN_DATA_7; \
																PIN_E_PORT->DIR |= PIN_E; \
																PIN_RW_PORT->DIR |= PIN_RW; \
																PIN_RS_PORT->DIR |= PIN_RS; \
																											}

/* Setting DATA pins to output mode                                            */
#define SET_LCD_DATA_DIR_OUT      { PIN_DATA_PORT_4->DIR |= PIN_DATA_4; \
																PIN_DATA_PORT_5->DIR |= PIN_DATA_5; \
																PIN_DATA_PORT_6->DIR |= PIN_DATA_6; \
																PIN_DATA_PORT_7->DIR |= PIN_DATA_7; \
																											}

/* Setting DATA pins to input mode                                           */
#define SET_LCD_DATA_DIR_IN     { PIN_DATA_PORT_4->DIR &= ~PIN_DATA_4; \
																PIN_DATA_PORT_5->DIR &= ~PIN_DATA_5; \
																PIN_DATA_PORT_6->DIR &= ~PIN_DATA_6; \
																PIN_DATA_PORT_7->DIR &= ~PIN_DATA_7; \
																											}



#define LCD_BUSY_FLAG_MASK				(0x80)

/******************************************************************************/
void Delay (uint32_t nCount);
void Init_LCD (void);
void Set_Cursor (uint8_t column, uint8_t row);
void Clear_LCD(void);
void Print_LCD (char *string);
void lcd_putchar (char c);
uint32_t GPIOGetValue( uint32_t portNum, uint32_t bitPosi );


// *******************************ARM University Program Copyright  ARM Ltd 2013*************************************   
