///**************************************************************************//**
// * @file     FlashDev.c
// * @brief    Flash Device Description for New Device Flash
// * @version  V1.0.0
// * @date     10. January 2018
// ******************************************************************************/
///*
// * Copyright (c) 2010-2018 Arm Limited. All rights reserved.
// *
// * SPDX-License-Identifier: Apache-2.0
// *
// * Licensed under the Apache License, Version 2.0 (the License); you may
// * not use this file except in compliance with the License.
// * You may obtain a copy of the License at
// *
// * www.apache.org/licenses/LICENSE-2.0
// *
// * Unless required by applicable law or agreed to in writing, software
// * distributed under the License is distributed on an AS IS BASIS, WITHOUT
// * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// * See the License for the specific language governing permissions and
// * limitations under the License.
// */
// 
#include "..\FlashOS.H"        // FlashOS Structures


//struct FlashDevice const FlashDevice  =  {
//   FLASH_DRV_VERS,             // Driver Version, do not modify!
//   "New Device 256kB Flash",   // Device Name 
//   ONCHIP,                     // Device Type
//   0x00000000,                 // Device Start Address
//   0x00040000,                 // Device Size in Bytes (256kB)
//   1024,                       // Programming Page Size
//   0,                          // Reserved, must be 0
//   0xFF,                       // Initial Content of Erased Memory
//   100,                        // Program Page Timeout 100 mSec
//   3000,                       // Erase Sector Timeout 3000 mSec

//// Specify Size and Address of Sectors
//   0x002000, 0x000000,         // Sector Size  8kB (8 Sectors)
//   0x010000, 0x010000,         // Sector Size 64kB (2 Sectors) 
//   0x002000, 0x030000,         // Sector Size  8kB (8 Sectors)
//   SECTOR_END
//};

//#include "FlashOS.h"

//struct FlashDevice {
//  U16     Vers;
//  char    DevName[128];
//  U16     DevType;
//  U32     DevAdr;
//  U32     szDev;
//  U32     szPage;
//  U32     Res;
//  U8      valEmpty;
//  U32     toProg;
//  U32     toErase;
//  U32     szSector;
//  U32     AddrSector;
//  U32     End;
//};

__attribute__((section(".FlashDevice")))
//const struct FlashDevice FlashDevice = {
//  0x0101,
//  "IS25LE02GG 256MB QuadSPI @ FlexSPI1A",
//  2,                  /* Ext8 */
//  0x30000000,         /* Base */
//  0x10000000,         /* 256MB */
//  256,                /* page */
//  0,
//  0xFF,
//  100,                /* ms */
//  6000,               /* ms */
//  0x1000,             /* 4KB */
//  0x00000000,
//  0xFFFFFFFF
//};

//struct FlashDevice const FlashDevice  =  {
//   FLASH_DRV_VERS,             // Driver Version, do not modify!
//   "New Device 64MB Flash",   // Device Name 
//   EXTSPI,//ONCHIP,                     // Device Type
//   0x30000000,                 // Device Start Address
//   0x04000000,                 // Device Size in Bytes (256kB)
//   1024,                       // Programming Page Size
//   0,                          // Reserved, must be 0
//   0xFF,                       // Initial Content of Erased Memory
//   100,                        // Program Page Timeout 100 mSec
//   3000,                       // Erase Sector Timeout 3000 mSec

//// Specify Size and Address of Sectors
//   0x002000, 0x000000,         // Sector Size  8kB (8 Sectors)
//   0x010000, 0x010000,         // Sector Size 64kB (2 Sectors) 
//   0x002000, 0x030000,         // Sector Size  8kB (8 Sectors)
//   SECTOR_END
//};
#define FLASH_AHB_BASE  (0x30000000u)   /* Your mapped XIP base */
#define FLASH_TOTAL_SZ  (0x08000000u)   /* 128MB (1Gb) */

struct FlashDevice const FlashDevice =  {
  FLASH_DRV_VERS,
  "PKISSI 1Gb (128MB) SPI NOR 3B+BAR @0x30000000 - SDKfree",
  EXTSPI,
  FLASH_AHB_BASE,
  FLASH_TOTAL_SZ,
  256,                  /* page */
  0,
  0xFF,
  100,                  /* program timeout (ms) */
  6000,                 /* sector erase timeout (ms) */
  0x1000, 0x00000000,   /* 4KB sectors from offset 0 */
  SECTOR_END
};


