# ###############################################################################
#
# Copyright (C) 2024 Arm Limited (or its affiliates). All rights reserved.
#
# Zephyr RTOS OS Awareness Extension for ARM Development Studio
#
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

from osapi      import *
from globs      import *
from contexts   import ContextsProvider
from kernel     import KernelData
from threads    import Threads
from timers     import Timers
from mutexes    import Mutexes
from semaphores import Semaphores
from msgqs      import MessageQueues
from fifos      import FIFOs

# this script effectively implements com.arm.debug.extension.os.IOSProvider

def getOSContextProvider():
    return ContextsProvider()

def getDataModel():
    return Model( OS_NAME, [ KernelData(), Threads(), Mutexes(), Semaphores(), MessageQueues(), FIFOs(), Timers() ] )

def isOSInitialised( debugger ):
    try:
        # Check if kernel structure exists and has a current thread
        if debugger.symbolExists( Z_KERNEL ):
            kernelExpr = debugger.evaluateExpression( Z_KERNEL )
            members = kernelExpr.getStructureMembers( )
            if Z_KERNEL_CURRENT in members:
                currentThread = members[ Z_KERNEL_CURRENT ]
                return currentThread.readAsNumber( ) != 0
        return False
    except DebugSessionException:
        return False

def areOSSymbolsLoaded( debugger ):
    # Check for essential Zephyr kernel symbols
    # The _kernel structure must be present along with thread-related symbols
    return debugger.symbolExists( Z_KERNEL ) and debugger.symbolExists( "k_thread" )
